<?php
// ==========================================================
// 🚨 ATIVAÇÃO DE EXIBIÇÃO DE ERROS PARA DEBUG 🚨
// ==========================================================
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Inclui o ficheiro de conexão à base de dados
include 'conexao.php';

// --- CAPTURA CONTEXTOS (PRIORIDADE: POST -> GET) ---
$ano_lectivo = $_POST['ano_lectivo'] ?? $_GET['ano_lectivo'] ?? '';
$turma_id    = $_POST['turma_id'] ?? $_GET['turma_id'] ?? ''; // Variável corrigida
$classe      = $_POST['classe'] ?? $_GET['classe'] ?? '';     // Variável corrigida
$curso       = $_POST['curso'] ?? $_GET['curso'] ?? '';       // Variável corrigida
$aluno_id    = $_POST['aluno_id'] ?? $_GET['aluno_id'] ?? ''; // Variável corrigida

// --- PROCESSAMENTO DO FORMULÁRIO (SALVAMENTO DE NOTAS) ---
if ($_SERVER["REQUEST_METHOD"] === "POST"
    && !empty($_POST['disciplina_id'])
    && !empty($aluno_id) && !empty($turma_id) && !empty($ano_lectivo)) {

    // Arrays vindos do form (proteção com ?? [])
    $disciplinas_ids = $_POST['disciplina_id'] ?? [];
    $mt1s    = $_POST['mt1'] ?? [];
    $mt2s    = $_POST['mt2'] ?? [];
    $mt3s    = $_POST['mt3'] ?? [];
    $mfds    = $_POST['mfd'] ?? [];
    $exames  = $_POST['exame'] ?? [];
    $mfs     = $_POST['mf'] ?? [];

    // Garantir tipos adequados (saneamento simples)
    $aluno_id = (int)$aluno_id;
    $turma_id = (int)$turma_id;
    $classe_post = trim($classe ?? '');
    $ano_lectivo_val = $ano_lectivo;

    // Valor fixo para a coluna 'trimestre', que é NOT NULL. (3 = Anual/Final)
    $trimestre_val = 3; 

    // PREPARE: Query com ON DUPLICATE KEY UPDATE
    // Colunas: aluno_id, turma_id, disciplina_id, ano_lectivo, trimestre, classe, mt1, mt2, mt3, mfd, exame, mf
    $sql = "INSERT INTO notas
        (aluno_id, turma_id, disciplina_id, ano_lectivo, trimestre, classe, mt1, mt2, mt3, mfd, exame, mf)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ON DUPLICATE KEY UPDATE
            trimestre = VALUES(trimestre),
            classe = VALUES(classe),
            mt1    = VALUES(mt1),
            mt2    = VALUES(mt2),
            mt3    = VALUES(mt3),
            mfd    = VALUES(mfd),
            exame  = VALUES(exame),
            mf     = VALUES(mf)
        ";

    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        error_log("Erro na preparação do statement de salvamento na tabela NOTAS: " . $conn->error);
        die("Ocorreu um erro interno na preparação da base de dados. Contacte o suporte.");
    }

    // Percorre disciplinas recebidas
    for ($i = 0; $i < count($disciplinas_ids); $i++) {
        
        $disc_id = isset($disciplinas_ids[$i]) ? (int)$disciplinas_ids[$i] : 0;

        // CRÍTICO: Se a nota for vazia (''), usa 0.0 (float) em vez de null.
        $mt1 = isset($mt1s[$i]) && $mt1s[$i] !== '' ? (float)$mt1s[$i] : 0.0;
        $mt2 = isset($mt2s[$i]) && $mt2s[$i] !== '' ? (float)$mt2s[$i] : 0.0;
        $mt3 = isset($mt3s[$i]) && $mt3s[$i] !== '' ? (float)$mt3s[$i] : 0.0;
        $mfd = isset($mfds[$i]) && $mfds[$i] !== '' ? (float)$mfds[$i] : 0.0;
        $ex  = isset($exames[$i]) && $exames[$i] !== '' ? (float)$exames[$i] : 0.0;
        $mf  = isset($mfs[$i]) && $mfs[$i] !== '' ? (float)$mfs[$i] : 0.0;

        // NOVO: 12 PARÂMETROS
        // i=aluno, i=turma, i=disciplina, s=ano, i=trimestre, s=classe, d...d=notas (6x float/double)
        $types = "iiisisdddddd"; 

        $bind_params = [
            $aluno_id,
            $turma_id,
            $disc_id,
            $ano_lectivo_val,
            $trimestre_val,
            $classe_post,
            $mt1,
            $mt2,
            $mt3,
            $mfd,
            $ex,
            $mf
        ];

        // Bind parameters usando referências
        $tmp = [];
        foreach ($bind_params as $key => $value) $tmp[$key] = &$bind_params[$key];

        if (!call_user_func_array([$stmt, 'bind_param'], array_merge([$types], $tmp))) {
            error_log("Erro no bind_param: " . $stmt->error);
            die("Ocorreu um erro interno ao ligar dados. Contacte o suporte.");
        }

        if (!$stmt->execute()) {
            error_log("Erro ao executar insert/update: " . $stmt->error);
            die("Erro ao salvar dados na base de dados. Contacte o suporte.");
        }
    }

    $stmt->close();
    
    // ==========================================================
    // Implementação do padrão Post/Redirect/Get (PRG) 
    // ==========================================================
    $redirect_url = basename($_SERVER['PHP_SELF']) . 
                    "?aluno_id={$aluno_id}" . 
                    "&turma_id={$turma_id}" . 
                    "&classe=" . urlencode($classe_post) .
                    "&curso=" . urlencode($curso) . 
                    "&ano_lectivo=" . urlencode($ano_lectivo_val);

    echo "<script>alert('Notas salvas ou atualizadas com sucesso na tabela NOTAS!'); window.location.href = '{$redirect_url}';</script>";
    exit(); 
}

// --- BUSCA DADOS DO ALUNO ---
$dados_aluno = null;
$data_emissao_bi_formatada = '';
$dia_nasc = $mes_nasc = $ano_nasc = '';
if (!empty($aluno_id)) {
    $campos_selecionados = "nome, data_nascimento, genero, bi_numero, naturalidade, municipio, provincia, nome_pai, nome_mae, endereco, contacto, bi_emitido_em, bi_data_emissao, numero_processo, classe";
    $stmt_aluno = $conn->prepare("SELECT $campos_selecionados FROM alunos WHERE id = ?");
    $stmt_aluno->bind_param("i", $aluno_id);
    $stmt_aluno->execute();
    $resultado = $stmt_aluno->get_result();
    if ($resultado->num_rows > 0) {
        $dados_aluno = $resultado->fetch_assoc();
        
        if (!empty($dados_aluno['data_nascimento'])) {
            $data_nascimento_obj = new DateTime($dados_aluno['data_nascimento']);
            $dia_nasc = $data_nascimento_obj->format('d');
            // Formata o mês em português
            setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'portuguese'); 
            $mes_nasc = strftime('%B', $data_nascimento_obj->getTimestamp());
            $ano_nasc = $data_nascimento_obj->format('Y');
        }
        if (!empty($dados_aluno['bi_data_emissao'])) {
            $data_emissao_obj = new DateTime($dados_aluno['bi_data_emissao']);
            $data_emissao_bi_formatada = str_pad($data_emissao_obj->format('d'), 2, '0', STR_PAD_LEFT) . ' de ' . strftime('%B', $data_emissao_obj->getTimestamp()) . ' de ' . $data_emissao_obj->format('Y');
        }
    }
    $stmt_aluno->close();
}

// --- DADOS PARA O FORMULÁRIO (TURMAS, ALUNOS) ---
$anos = []; for ($i = 2024; $i <= 2030; $i++) { $anos[] = "$i/" . ($i + 1); }

// Turmas
$turmas = []; $turmasDataFull = [];
$res = $conn->query("SELECT id, nome, classe, curso, turno as periodo FROM turmas ORDER BY nome");
if ($res) {
    while ($row = $res->fetch_assoc()) {
        $turmas[] = $row;
        // Corrigido: garantindo que 'nome' esteja aqui para o cabeçalho contextual
        $turmasDataFull[$row['id']] = ['nome' => $row['nome'] ?? '', 'classe' => $row['classe'] ?? '', 'curso' => $row['curso'] ?? '', 'periodo' => $row['periodo'] ?? ''];
    }
} else {
    die("ERRO BD (Turmas): " . $conn->error);
}

// Disciplinas para o Formulário de Input (Usando a tabela 'disciplinas' diretamente)
$disciplinas_form = [];
if ($turma_id && $ano_lectivo) {
    $stmt = $conn->prepare("
        SELECT DISTINCT id, nome
        FROM disciplinas
        WHERE turma_id = ? AND ano_lectivo = ?
        ORDER BY nome ASC
    ");
    $stmt->bind_param("is", $turma_id, $ano_lectivo);
    $stmt->execute();
    $res = $stmt->get_result();
    while ($row = $res->fetch_assoc()) {
        $disciplinas_form[] = ['id' => (int)$row['id'], 'nome' => $row['nome']];
    }
    $stmt->close();
}

// Alunos agrupados por turma
$alunosPorTurma = [];
$res = $conn->query("SELECT id, nome, turma_id FROM alunos ORDER BY nome");
if ($res) {
    while ($row = $res->fetch_assoc()) {
        $alunosPorTurma[$row['turma_id']][] = $row;
    }
} else {
    die("ERRO BD (Alunos): " . $conn->error);
}

// Notas existentes (para preencher o formulário)
// IMPORTANTE: Busca apenas as notas do trimestre fixo (3) para o aluno/turma/ano selecionados.
$notasExistentes = [];
if (!empty($aluno_id) && !empty($turma_id) && !empty($ano_lectivo)) {
    $trimestre_val_fetch = 3; // Trimestre fixo
    $stmt_notas_existentes = $conn->prepare("SELECT * FROM notas WHERE aluno_id = ? AND turma_id = ? AND ano_lectivo = ? AND trimestre = ?");
    $stmt_notas_existentes->bind_param("iisi", $aluno_id, $turma_id, $ano_lectivo, $trimestre_val_fetch);
    $stmt_notas_existentes->execute();
    $resultado_notas = $stmt_notas_existentes->get_result();
    
    while ($row = $resultado_notas->fetch_assoc()) {
        // Mapeia por chave: aluno_turma_disciplinaid_ano
        $chave_edicao = $row['aluno_id'] . '_' . $row['turma_id'] . '_' . $row['disciplina_id'] . '_' . $row['ano_lectivo'];
        $notasExistentes[$chave_edicao] = $row;
    }
    $stmt_notas_existentes->close();
}


// --- CONTEXTO PARA IMPRESSÃO (O ANO/TURMA/ALUNO ATUAL) ---
$tabelaAtual = null;
if (!empty($aluno_id) && !empty($turma_id) && !empty($ano_lectivo)) {
    // Busca dados da turma atual
    $turma_info_atual = $turmasDataFull[$turma_id] ?? ['classe' => $classe, 'curso' => $curso];

    // 1. Preparar a lista de disciplinas
    $disciplinas_lista = [];
    foreach ($disciplinas_form as $d) {
        $disciplinas_lista[] = ['id' => (int)$d['id'], 'nome' => $d['nome']];
    }

    // 2. Buscar as notas (da tabela Notas) por aluno/turma/ano/trimestre
    $notas_map = [];
    $notas_query = "SELECT disciplina_id, mt1, mt2, mt3, mfd, exame, mf FROM notas WHERE aluno_id = ? AND turma_id = ? AND ano_lectivo = ? AND trimestre = ?";
    $stmt_notas = $conn->prepare($notas_query);
    $trimestre_val_fetch = 3; // Trimestre fixo
    $stmt_notas->bind_param("iisi", $aluno_id, $turma_id, $ano_lectivo, $trimestre_val_fetch);
    $stmt_notas->execute();
    $res_notas = $stmt_notas->get_result();
    while ($n_row = $res_notas->fetch_assoc()) {
        $notas_map[(int)$n_row['disciplina_id']] = $n_row;
    }
    $stmt_notas->close();

    $tabelaAtual = [
        'ano_lectivo' => $ano_lectivo,
        'classe' => $turma_info_atual['classe'],
        'curso' => $turma_info_atual['curso'],
        'disciplinas' => $disciplinas_lista,
        'notas' => $notas_map
    ];
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Termos Anteriores</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        /* ========================================================== */
        /* ESTILOS GERAIS */
        /* ========================================================== */

        body { 
            font-family: 'Times New Roman', Times, serif; 
            background: #f4f6f9; 
            padding: 10px; 
        }
        .box { background: white; padding: 15px; border-radius: 6px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); margin-bottom: 20px; }
        .context-header { border-left: 5px solid darkred; background: #ffe6e6; padding: 10px 15px; margin-bottom: 20px; }
        select, input[type=text], input[type=number] { padding: 6px; border: 1px solid #ccc; border-radius: 5px; width: 100%; }
        label { font-weight: bold; margin-top: 10px; display: block; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { border: 1px solid #ccc; padding: 5px; text-align: center; font-size: 14px; }
        .form-row { display: flex; flex-wrap: wrap; gap: 10px; }
        .form-row > div { flex: 1 1 120px; }
        button { padding: 10px 20px; margin-top: 15px; background: #007bff; border: none; color: white; border-radius: 4px; cursor: pointer; }
        button:hover { background: #0056b3; }
        
        .cabecalho-termo h3 { border: 1px solid black; padding: 5px; font-weight: normal; }
        .insignia-container { text-align: center; margin-bottom: 15px; }
        .insignia-container img { width: 80px; }
        .cabecalho-termo .school-info { text-align: center; }

        /* Estilos para blocos de informação no termo */
        .info-complementar, .media-transita-obs, .registo-biografico {
            font-family: 'Times New Roman', Times, serif;
            font-size: 1.0em;
            line-height: 1.8;
            margin-top: 20px;
            text-align: left;
        }
        .assinaturas {
            font-family: 'Times New Roman', Times, serif;
            font-size: 1.0em;
            margin-top: 40px; 
            /* Não definir alinhamento aqui, será definido em linha */
        }
        .assinaturas div { margin-top: 40px; }

        #printTermoLayout { display: none; }


        /* ========================================================== */
        /* ESTILOS DE IMPRESSÃO (A4 Vertical - 1 página) */
        /* ========================================================== */
        @media print {
            @page { 
                size: A4 portrait; 
                margin: 0.5cm; 
            }
            
            body { 
                font-size: 8pt; 
                font-family: 'Times New Roman', Times, serif; 
            }
            
            .box, .form-row, form button, .context-header {
                display: none !important;
            }
            
            #printTermoLayout {
                display: block !important;
                margin-top: 0;
            }
            
            .insignia-container { margin-bottom: 5px; }

            .cabecalho-termo { margin-bottom: 5px !important; padding-bottom: 5px; }
            .cabecalho-termo h2 { font-size: 1.1em; margin: 3px 0; }
            .cabecalho-termo h3 { margin: 10px 0; font-size: 1em; padding: 3px; }

            .tabela-historico th, .tabela-historico td { 
                font-size: 7.5pt; 
                padding: 1px 1px; 
                border: 1px solid #000;
            }
            .tabela-historico th:nth-child(1) { width: 35%; text-align: left; padding-left: 3px; } 
            .tabela-historico td:nth-child(1) { text-align: left; padding-left: 3px; } 
            
             .nome-aluno-print { color: red; font-weight: bold; }
             .no-underline { text-decoration: none !important; }

             /* Ajustar fonte e margem para os novos blocos */
             .info-complementar, .media-transita-obs, .registo-biografico {
                font-size: 7.5pt !important;
                line-height: 1.5;
                margin-top: 10px;
             }
             .assinaturas {
                 font-size: 7.5pt !important;
                 margin-top: 30px !important; 
             }
             .assinaturas p { margin: 3px 0; }

             /* Estilo para alinhar as 3 últimas assinaturas */
             .assinaturas .flex-signatures {
                 display: flex;
                 justify-content: space-between;
                 width: 100%;
                 margin-top: 50px !important; /* Espaço para assinatura */
             }
             .assinaturas .flex-signatures div {
                 flex: 1;
                 margin: 0 5px; /* Pequeno espaçamento entre elas */
                 text-align: center;
             }
             .assinaturas .flex-signatures p { margin: 0; }
        }
    </style>
</head>
<body>

<?php 
// Variáveis para preenchimento
$classe_display = $classe ?? '____';
$ano_lectivo_display = str_replace('/', ' / ', $ano_lectivo ?? '__________ / ___________');

$nome_aluno = htmlspecialchars($dados_aluno['nome'] ?? '');
$proc_individual = htmlspecialchars($dados_aluno['numero_processo'] ?? '____________');
$naturalidade_print = htmlspecialchars($dados_aluno['naturalidade'] ?? '____________________');
$municipio_print = htmlspecialchars($dados_aluno['municipio'] ?? '____________________');
$provincia_print = htmlspecialchars($dados_aluno['provincia'] ?? '____________________');
$nome_pai_print = htmlspecialchars($dados_aluno['nome_pai'] ?? '____________________');
$nome_mae_print = htmlspecialchars($dados_aluno['nome_mae'] ?? '____________________');
$bi_numero_print = htmlspecialchars($dados_aluno['bi_numero'] ?? '____________________');
$bi_emitido_em_print = htmlspecialchars($dados_aluno['bi_emitido_em'] ?? '____________________');
$endereco_print = htmlspecialchars($dados_aluno['endereco'] ?? '____________________');
$contacto_print = htmlspecialchars($dados_aluno['contacto'] ?? '____________________');
$encarregado = htmlspecialchars($dados_aluno['nome_pai'] ?? '____________________'); // Assumindo Pai como encarregado por padrão
$curso_display = htmlspecialchars($curso ?? '____________________________'); 
?>

<?php if ($dados_aluno): ?>
<div class="box context-header">
    <h2 style="margin: 0;">A Editar Notas de:</h2>
    <p style="font-size: 1.2em; font-weight: bold; color: darkred; margin: 5px 0;">
        <?= htmlspecialchars($nome_aluno) ?>
    </p>
    <p style="margin: 0;">
        <span style="font-weight: bold;">Turma:</span> <?= htmlspecialchars($turmasDataFull[$turma_id]['nome'] ?? 'N/A') ?> 
        | <span style="font-weight: bold;">Classe:</span> <?= htmlspecialchars($classe) ?>ª
        | <span style="font-weight: bold;">Ano Lectivo:</span> <?= htmlspecialchars($ano_lectivo) ?>
    </p>
</div>
<?php endif; ?>

<form method="POST">
    <?php if ($aluno_id): ?>
        <input type="hidden" name="aluno_id" value="<?= htmlspecialchars($aluno_id) ?>">
        <input type="hidden" name="turma_id" value="<?= htmlspecialchars($turma_id) ?>">
        <input type="hidden" name="classe" value="<?= htmlspecialchars($classe) ?>">
        <input type="hidden" name="curso" value="<?= htmlspecialchars($curso) ?>">
    <?php endif; ?>
    
    <div class="box">
        <h2>Preencher Notas do Ano Lectivo Selecionado</h2>

        <div class="form-row">
            <div>
                <label>Ano Lectivo</label>
                <select name="ano_lectivo" required onchange="onTurmaChange()">
                    <option value="">-- Selecione --</option>
                    <?php foreach ($anos as $ano): ?>
                    <option value="<?= $ano ?>" <?= ($ano == $ano_lectivo ? 'selected' : '') ?>><?= $ano ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div>
                <label>Turma</label>
                <select name="turma_id" id="turma_id" required onchange="onTurmaChange()">
                    <option value="">-- Selecione --</option>
                    <?php foreach ($turmas as $turma):
                        $display_nome = $turma['classe'] . '-' . 
                                        htmlspecialchars($turma['nome']) . '-' . 
                                        $turma['curso'] . '-' . 
                                        $turma['periodo'];
                    ?>
                    <option value="<?= $turma['id'] ?>" <?= ($turma['id'] == $turma_id ? 'selected' : '') ?>>
                        <?= $display_nome ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div>
                <label>Aluno</label>
                <select name="aluno_id" id="aluno_id" required onchange="atualizarNotas()">
                    <option value="">-- Selecione uma turma --</option>
                    <?php
                    if ($turma_id && isset($alunosPorTurma[$turma_id])) {
                        foreach ($alunosPorTurma[$turma_id] as $aluno) {
                            $selected = ($aluno['id'] == $aluno_id ? 'selected' : '');
                            echo "<option value=\"{$aluno['id']}\" $selected>" . htmlspecialchars($aluno['nome']) . "</option>";
                        }
                    }
                    ?>
                </select>
            </div>
        </div>

        <div id="tabelaNotas" class="tabela-notas-container"> 
            <table>
                <thead>
                    <tr>
                        <th>Disciplina</th><th>MT1</th><th>MT2</th><th>MT3</th><th>MFD</th><th>Exame</th><th>MF</th>
                    </tr>
                </thead>
                <tbody id="linhasNotas">
                    <?php
                    // Renderiza as disciplinas ATRIBUÍDAS para a turma/ano selecionado
                    $disciplinas_turma_atual = $disciplinas_form;
                    
                    if (!empty($disciplinas_turma_atual) && !empty($turma_id) && !empty($ano_lectivo)):
                        foreach ($disciplinas_turma_atual as $disciplina):
                            $chave = $aluno_id . '_' . $turma_id . '_' . $disciplina['id'] . '_' . $ano_lectivo;
                            $nota = $notasExistentes[$chave] ?? [];
                            $readonly = (empty($aluno_id) ? 'readonly' : '');
                    ?>
                            <tr>
                                <td>
                                    <input type="hidden" name="disciplina_id[]" value="<?= (int)$disciplina['id'] ?>">
                                    <?= htmlspecialchars($disciplina['nome']) ?>
                                </td>
                                
                                <td><input type="number" name="mt1[]" step="0.01" 
                                    value="<?= isset($nota['mt1']) ? number_format((float)$nota['mt1'], 2, '.', '') : '' ?>" 
                                    <?= $readonly ?>></td>
                                <td><input type="number" name="mt2[]" step="0.01" 
                                    value="<?= isset($nota['mt2']) ? number_format((float)$nota['mt2'], 2, '.', '') : '' ?>" 
                                    <?= $readonly ?>></td>
                                <td><input type="number" name="mt3[]" step="0.01" 
                                    value="<?= isset($nota['mt3']) ? number_format((float)$nota['mt3'], 2, '.', '') : '' ?>" 
                                    <?= $readonly ?>></td>
                                <td><input type="number" name="mfd[]" step="0.01" 
                                    value="<?= isset($nota['mfd']) ? number_format((float)$nota['mfd'], 2, '.', '') : '' ?>" 
                                    <?= $readonly ?>></td> 
                                <td><input type="number" name="exame[]" step="0.01" 
                                    value="<?= isset($nota['exame']) ? number_format((float)$nota['exame'], 1, '.', '') : '' ?>" 
                                    <?= $readonly ?>></td>
                                <td><input type="number" name="mf[]" step="0.01" 
                                    value="<?= isset($nota['mf']) ? number_format((float)$nota['mf'], 1, '.', '') : '' ?>" 
                                    <?= $readonly ?>></td>
                            </tr>
                    <?php
                        endforeach;
                    else:
                    ?>
                        <tr><td colspan="7">Selecione um **Ano Letivo**, uma **Turma** e um **Aluno** para carregar as disciplinas e notas.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <button type="submit" <?= (empty($aluno_id) || empty($turma_id) || empty($ano_lectivo) ? 'disabled' : '') ?>>Salvar Notas (Tabela Notas)</button>
            <button type="button" onclick="window.print()">Imprimir Termo</button>
        </div>
    </div>
</form>


<?php if ($dados_aluno && $tabelaAtual): 
    $data = $tabelaAtual;
?>
<div id="printTermoLayout">
    
    <div class="insignia-container">
        <img src="insignia/insignia.png" alt="Insígnia">
    </div>

    <div class="cabecalho-termo">
        <div class="school-info">
            <p style="margin: 0;">REPÚBLICA DE ANGOLA</p>
            <p style="margin: 0;">GOVERNO PROVINCIAL DE BENGUELA</p>
            <p style="margin: 0;">GABINETE PROVINCIAL DA EDUCAÇÃO</p>
            <h2 style="margin: 5px 0 10px 0; font-size: 1.4em;">COMPLEXO ESCOLAR BG 0026 PADRE EMIL FRICK – CATUMBELA</h2>
        </div>

        <h3 style="text-align: center; margin: 15px 0;">
            TERMO DE MATRÍCULA, FREQUÊNCIA, APROVEITAMENTO E EXAME Nº _______/_____ Nº PROC. INDIVIDUAL <?= $proc_individual ?>
        </h3>

        <div style="font-family: 'Times New Roman', Times, serif; font-size: 1.1em; line-height: 1.5; text-align: left;"> 
            Nome: <span class="nome-aluno-print"><?= $nome_aluno ?></span>, nascido (a) aos <span class="no-underline"><?= $dia_nasc ?? '___' ?></span> de <span class="no-underline"><?= $mes_nasc ?? '__________________' ?></span> de <span class="no-underline"><?= $ano_nasc ?? '____' ?></span> natural de 
            <br>
            <span class="no-underline"><?= $naturalidade_print ?></span> Município <span class="no-underline"><?= $municipio_print ?></span>, Província <span class="no-underline"><?= $provincia_print ?></span> Filho de <span class="no-underline"><?= $nome_pai_print ?></span> e de <span class="no-underline"><?= $nome_mae_print ?></span>
            <br>
            B.I Nº <span class="no-underline"><?= $bi_numero_print ?></span> emitido em <span class="no-underline"><?= $bi_emitido_em_print ?></span> aos <span class="no-underline"><?= $data_emissao_bi_formatada ?? '____________________________' ?></span>
            <br>
            Residente em <span class="no-underline"><?= $endereco_print ?></span> Encarregado de Educação <span class="no-underline"><?= $encarregado ?></span> contacto(s) <span class="no-underline"><?= $contacto_print ?></span>/ <span class="no-underline">____________________________</span>
            <br>
            <br>
            <span class="no-underline"><?= $classe_display ?></span>ª Classe, Área de <span class="no-underline"><?= $curso_display ?></span> Ano Lectivo <span class="no-underline"><?= $ano_lectivo_display ?></span>
        </div>
    </div>
    
    <div class="termo-tabela-box">
        <h4 style="text-align: center; margin: 0 0 10px 0; font-size: 1.1em; border-bottom: 1px solid #000; padding-bottom: 5px;">
            <?= htmlspecialchars($data['classe']) ?>ª Classe | <?= htmlspecialchars($data['curso']) ?> | Ano Lectivo: **<?= htmlspecialchars($data['ano_lectivo']) ?>**
        </h4>
        <table class="tabela-historico">
            <thead>
                <tr>
                    <th>Disciplina</th>
                    <th>MT1</th>
                    <th>MT2</th>
                    <th>MT3</th>
                    <th>MFD</th>
                    <th>Exame</th>
                    <th>MF</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($data['disciplinas'])): ?>
                    <?php foreach ($data['disciplinas'] as $disciplina_row): 
                        $disciplina_nome = htmlspecialchars($disciplina_row['nome']);
                        $nota = $data['notas'][(int)$disciplina_row['id']] ?? [];
                    ?>
                        <tr>
                            <td><?= $disciplina_nome ?></td>
                            <td><?= isset($nota['mt1']) ? number_format((float)$nota['mt1'], 2, ',', '.') : '0,00' ?></td>
                            <td><?= isset($nota['mt2']) ? number_format((float)$nota['mt2'], 2, ',', '.') : '0,00' ?></td>
                            <td><?= isset($nota['mt3']) ? number_format((float)$nota['mt3'], 2, ',', '.') : '0,00' ?></td>
                            <td><?= isset($nota['mfd']) ? number_format((float)$nota['mfd'], 2, ',', '.') : '0,00' ?></td>
                            <td><?= isset($nota['exame']) ? number_format((float)$nota['exame'], 1, ',', '.') : '0,0' ?></td>
                            <td><strong><?= isset($nota['mf']) ? number_format((float)$nota['mf'], 1, ',', '.') : '0,0' ?></strong></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="7">Não há disciplinas atribuídas para esta turma/ano.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    
    <div class="media-transita-obs">
        <div style="display: flex; justify-content: space-between;">
            <p style="flex: 0 0 50%; margin: 3px 0;">
                Média Anual: <span class="no-underline" style="text-decoration: underline;">_________</span> ( <span class="no-underline" style="text-decoration: underline;">____________________________________</span>)
            </p>
            <p style="flex: 0 0 45%; margin: 3px 0;">
                Obs: <span class="no-underline" style="text-decoration: underline;">__________________________________________________</span>
            </p>
        </div>
        <p style="margin: 3px 0;">
            <span style="font-weight: bold;">Transita/Aprovado</span> (Azul) / <span style="font-weight: bold;">N/Transita/Reprovado</span> (Vermelho)
            <span class="no-underline" style="text-decoration: underline;">__________________________________________________</span>
        </p>
    </div>

    <div class="info-complementar">
        <p>
            Transferido(a) de ou para: <span class="no-underline" style="text-decoration: underline;">______________________________________________________________________________________________________________________________________________________</span>
        </p>
        <p>
            Assiduidade: <span class="no-underline" style="text-decoration: underline;">_________________________________________________________________________________________________________________________________________________________________</span>
        </p>
        <p>
            Tendências relevadas: <span class="no-underline" style="text-decoration: underline;">__________________________________________________________________________________________________________________________________________________________</span>
        </p>
        <p>
            Disciplinas de maior aproveitamento: <span class="no-underline" style="text-decoration: underline;">_________________________________________________________________________________________________________________________________________</span>
        </p>
        <p>
            Data da Conclusão do Curso: <span class="no-underline" style="text-decoration: underline;">_____________/____________________________/___________</span>
        </p>
        <p>
            Média Final do Curso: <span class="no-underline" style="text-decoration: underline;">_________</span> ( <span class="no-underline" style="text-decoration: underline;">_________________________________________________________________________________________________________________________________________</span>)
        </p>
    </div>

    <div class="registo-biografico">
        <p style="font-weight: bold; margin-bottom: 5px;">REGISTO BIOGRÁFICO</p>
        <p>
            Prémios: <span class="no-underline" style="text-decoration: underline;">_________________________________________________________________________________</span> Outras observações <span class="no-underline" style="text-decoration: underline;">____________________________________________________________________________</span>
        </p>
        <p>
            Comportamento: <span class="no-underline" style="text-decoration: underline;">_________________________________________________________________________________</span> <span class="no-underline" style="text-decoration: underline;">____________________________________________________________________________________________________________</span>
        </p>
    </div>

    <div class="assinaturas">
        <p style="text-align: right; margin-bottom: 30px;">
            Catumbela, <span class="no-underline" style="text-decoration: underline;">_______</span> de <span class="no-underline" style="text-decoration: underline;">___________________</span> de <span class="no-underline" style="text-decoration: underline;">____________</span>
        </p>
        
        <div class="flex-signatures">
            <div style="flex: 1; text-align: center;">
                <p style="border-top: 1px solid black; padding-top: 5px; width: 80%; margin: 0 auto;"></p>
                <p>O (A) Director(a) de Turma</p>
            </div>
             <div style="flex: 1; text-align: center;">
                <p style="border-top: 1px solid black; padding-top: 5px; width: 80%; margin: 0 auto;"></p>
                <p>O (A) Secretário(a) Escolar</p>
            </div>
            <div style="flex: 1; text-align: center;">
                <p style="border-top: 1px solid black; padding-top: 5px; width: 80%; margin: 0 auto;"></p>
                <p>O (A) Director(a) da Escola</p>
            </div>
        </div>
    </div>

</div>
<?php endif; ?>


<script>
// Mapa de dados para a parte interativa.
const turmasDataFull = <?= json_encode($turmasDataFull) ?>;

// --- FUNÇÃO PRINCIPAL DE MUDANÇA DE TURMA/ANO ---
function onTurmaChange() {
    const turmaId = document.getElementById('turma_id').value;
    const anoLectivo = document.querySelector('select[name="ano_lectivo"]').value;
    
    const currentUrl = new URL(window.location.href);
    currentUrl.searchParams.set('ano_lectivo', anoLectivo);
    
    if (turmaId && turmasDataFull[turmaId]) {
        const turma = turmasDataFull[turmaId];
        currentUrl.searchParams.set('turma_id', turmaId);
        currentUrl.searchParams.set('classe', turma.classe);
        currentUrl.searchParams.set('curso', turma.curso || turma.course); 
    } else {
        currentUrl.searchParams.delete('turma_id');
        currentUrl.searchParams.delete('classe');
        currentUrl.searchParams.delete('curso');
        currentUrl.searchParams.delete('aluno_id');
    }
    
    window.location.href = currentUrl.toString();
}

// --- FUNÇÃO CHAMADA NA MUDANÇA DE ALUNO (Atualiza inputs e recarrega a página) ---
function atualizarNotas() {
    const alunoId = document.getElementById('aluno_id').value;
    const currentUrl = new URL(window.location.href);
    currentUrl.searchParams.set('aluno_id', alunoId);
    
    window.location.href = currentUrl.toString();
}
</script>

</body>
</html>